<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "classi/TabellaPrezzi.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento = $geecomDb->leggiSingolaRiga("geec_colonneTabellaPrezzi",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        
        $tabella = new TabellaPrezzi($geecomDb, $elemento["idTabella"]);
        $tabella->caricaDatiDalDatabase();
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione colonna tabella prezzi</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Colonna tabella modificata
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" name="operazione" value="<?php echo((isset($elemento) ? "modificaElemento" : "crea")); ?>">
                        <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                        <div class="col-lg-12 ">
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-12 col-lg-6 d-md-flex">
                                            <h6 class="mt-2 mr-2 text-nowrap">Colonna:</h6>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome elemento" value="<?php echo((isset($elemento) ? $elemento["nome"] : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col text-right">
                                            <a class="btn btn-outline-primary mt-2 mt-lg-0" href="creaTabella.php?id=<?php echo $elemento["idTabella"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary mt-2 mt-lg-0" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                            <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo $elemento["idTabella"] ?>&operazione=duplicaElemento&idElemento=<?php echo $elemento["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-5">
                                            <div class="row">
                                                <div class="form-group col-12">
                                                    <input type="checkbox" name="preferita" value="si" class="js-switch" <?php echo((isset($elemento) && $elemento["preferita"]=="si") ? "checked" : "1") ?> value="si">
                                                    <label class="ml-2">Più gettonata</label>
                                                </div>
                                                
                                                <div class="form-group col-12">
                                                    <label for="titolo-articolo">Descrizione</label>
                                                    <textarea rows="4" class="form-control" name="descrizione" placeholder="Descrizione"><?php echo((isset($elemento)? $elemento["descrizione"] : ""))?></textarea>
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Link pulsante</label>
                                                    <input  type="text" class="form-control" name="link" value="<?php echo((isset($elemento)? $elemento["link"] : ""))?>" placeholder="Link">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Etichetta pulsante</label>
                                                    <input  type="text" class="form-control" name="etichettaLink" value="<?php echo((isset($elemento)? $elemento["etichettaLink"] : ""))?>" placeholder="Etichetta link">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Prezzo</label>
                                                    <input  type="text" class="form-control" name="prezzo" value="<?php echo((isset($elemento)? $elemento["prezzo"] : ""))?>" placeholder="Prezzo">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Prezzo scontato</label>
                                                    <input  type="text" class="form-control" name="prezzoScontato" value="<?php echo((isset($elemento)? $elemento["prezzoScontato"] : ""))?>" placeholder="Prezzo scontato">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Valuta</label>
                                                    <input  type="text" class="form-control" name="valuta" value="<?php echo((isset($elemento)? $elemento["valuta"] : ""))?>" placeholder="Valuta">
                                                </div>

                                                <div class="form-group col-md-6">
                                                    <label for="titolo-articolo">Suffisso</label>
                                                    <input  type="text" class="form-control" name="suffisso" value="<?php echo((isset($elemento)? $elemento["suffisso"] : ""))?>" placeholder="Suffisso">
                                                </div>
                                            </div>
                                        </div>
                    </form>
                                        
                                        <div class="col-lg-3">
                                            <div class="img-container">
                                                <div class="azioni">
                                                    <div class="btn-group" role="group" aria-label="">
                                                        <button onclick="eliminaImmagineElemento()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                                    </div>
                                                </div>
                                                <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($elemento) && $elemento["immagine"]!="") ? $elemento["immagine"] : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                            </div>

                                            <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                            <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                                <div class="dz-message">
                                                    <i class="fas fa-file-upload fa-2x mb-2"></i>
                                                    <h5>Trascina o carica qui l'immagine</h5>
                                                </div>
                                                <div class="fallback">
                                                    <input name="file" type="file" />
                                                </div>
                                            </form>
                                        </div>
                                        
                                        <div class="col-lg-4">
                                            
                                                <?php 
                                                    if(isset($elemento)) {
                                                ?>
                                                    
                                                        <form>
                                                            <div class="mb-4 add-box">
                                                                <h5 class="mb-3"> Aggiungi elemento colonna </h5>
                                                                <div class="options-box">
                                                                    <div class="form-group">
                                                                        <label>Nome</label>
                                                                        <input type="text" class="form-control" id="nomeElemento" placeholder="Nome">
                                                                    </div>
                                                                    
                                                                    <div class="row">
                                                                        <div class="form-group col-md-6">
                                                                            <label>Icona</label>
                                                                            <input type="text" class="form-control" id="iconaElemento"  placeholder="Icona">
                                                                        </div>

                                                                        <div class="form-group col-md-6">
                                                                            <label>Classe</label>
                                                                            <input type="text" class="form-control" id="classeElemento"  placeholder="Classe elemento">
                                                                        </div>
                                                                    </div>

                                                                    <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElementoColonna()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                                </div>
                                                            </div>
                                                        </form>

                                                        <div id="divElencoElementiColonna" class="gerarchia-menu">
                                                            <?php 
                                                                $tabella->stampaElementiColonna($elemento["id"]);
                                                            ?>
                                                        </div>
                                                <?php
                                                    }
                                                ?>
                                        </div>
                                    </div>
                                    
                            </div>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../include/modal/eliminaElemento.php";
        ?>
        <div class="modal fade" id="modifica-elemento-colonna" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica elemento colonna</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <input type="text" class="d-none" id="idElementoColonnaDaModificare" name="id">

                            <div class="form-group">
                                <label for="nome-voce-menu-1">Nome</label>
                                <input type="text" class="form-control" id="nomeElementoColonnaDaModificare" name="nome" placeholder="Nome">
                            </div>
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-1">Icona</label>
                                <input type="text" class="form-control" id="iconaElementoColonnaDaModificare" name="icona" placeholder="Icona">
                            </div>
                            
                            <div class="form-group">
                                <label for="nome-voce-menu-1">Classe</label>
                                <input type="text" class="form-control" id="classeElementoColonnaDaModificare" name="classe" placeholder="Classe">
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaElemento()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>
        <?php    
            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../../include/modal/modalSelezionaFoto.php";
            
            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineInEvidenza").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

        <script>
            function creaElementoColonna() {
                var nome   = $('#nomeElemento').val();
                var icona  = $('#iconaElemento').val();
                var classe = $('#classeElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElementoColonna",
                        id:<?php echo $tabella->getId() ?>,
                        idColonna:<?php echo $elemento["id"] ?>,
                        nome:nome,
                        icona:icona,
                        classe:classe
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementiColonna",
                        id:<?php echo $tabella->getId() ?>,
                        idColonna:<?php echo $elemento["id"] ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementiColonna").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElementoColonna",
                        id:<?php echo $tabella->getId() ?>,
                        idColonna:<?php echo $elemento["id"] ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function modificaElementoColonna(id,nome,icona,classe) {
                $('#idElementoColonnaDaModificare').val(id);
                $('#nomeElementoColonnaDaModificare').val(nome);
                $('#iconaElementoColonnaDaModificare').val(icona);
                $('#classeElementoColonnaDaModificare').val(classe);
                $('#modifica-elemento-colonna').modal('show');
            }
            
            function eseguiModificaElemento() {
                var id     = $('#idElementoColonnaDaModificare').val();
                var nome   = $('#nomeElementoColonnaDaModificare').val();
                var icona  = $('#iconaElementoColonnaDaModificare').val();
                var classe = $('#classeElementoColonnaDaModificare').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaElementoColonna",
                        id:<?php echo $tabella->getId() ?>,
                        idElemento:id,
                        nome:nome,
                        icona:icona,
                        classe:classe
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            $('#modifica-elemento-colonna').modal('hide');
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElementoColonna",
                        id:<?php echo $tabella->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                modificaImmagineElementoComponente(<?php echo $elemento["id"] ?>,percorso);
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $elemento["id"] ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
